#include "DTreeView.h"

#ifndef DWL_MSGRESULT
    #define DWL_MSGRESULT 0
#endif

namespace DWL {

    // Constructor.
	DTreeView::DTreeView(void) {
		INITCOMMONCONTROLSEX Comm;
		Comm.dwSize = sizeof(INITCOMMONCONTROLSEX);
		Comm.dwICC = ICC_TREEVIEW_CLASSES;
		InitCommonControlsEx(&Comm);
//		_ColorSeleccion = GetSysColor(COLOR_HIGHLIGHT); 
//		_ColorSeleccionTexto = GetSysColor(COLOR_HIGHLIGHTTEXT); 
	}



	// Destructor.
	DTreeView::~DTreeView(void) {
		for (unsigned int i = 0; i < _Nodos.size(); i++) { 
			delete _Nodos[i]; 
		} 
	};



	// Funcin para crear el TreeView.
	HWND DTreeView::Crear(DBaseWnd *nPadre, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, DWORD nEstilos, DWORD nEstilosExtendidos) {
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
		_hWnd = CreateWindowEx(nEstilosExtendidos, WC_TREEVIEW, NULL, nEstilos, cX, cY, cAncho, cAlto, nPadre->hWnd(), reinterpret_cast<HMENU>(IntToPtr(cID)), GetModuleHandle(NULL), NULL);
		_ConectarControl(cID, nPadre); 
		_Fuente = (HFONT)SendMessage(_hWnd, WM_GETFONT, 0, 0); 
		ColorFondo(GetSysColor(COLOR_WINDOW)); 
		ColorTexto(GetSysColor(COLOR_WINDOWTEXT)); 
        return _hWnd;
	};




	// Funcin para asignar esta clase a un TreeView creado anteriormente en el editor de recursos.
	void DTreeView::Asignar(DBaseWnd *nPadre, const UINT cID) { 
        if (nPadre == NULL) throw (DError(this, __PROTOTIPO_FUNCION__, DEnum_Error_BaseWndNULL)); 
		_hWnd = GetDlgItem(nPadre->hWnd(), cID); 
		_ConectarControl(cID, nPadre); 
		_Fuente = (HFONT)SendMessage(_hWnd, WM_GETFONT, 0, 0); 
	};




	// Funcines para Agregar un Nodo partiendo de una clase derivada de DTreeView_Nodo.
	HTREEITEM DTreeView::AgregarNodo(DTreeView_Nodo *nNodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe) {
		TVINSERTSTRUCT ITS; 
		TVITEM         Item;
		TCHAR          Tmp[128];
		DWLStrCopy(Tmp, 128, cTexto);
		Item.pszText = Tmp;
		Item.cchTextMax = static_cast<int>(DWLStrLen(Tmp));
		Item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;
		Item.state = TVIS_SELECTED;
		Item.stateMask = TVIS_SELECTED; 
		Item.iImage = cIko; Item.iSelectedImage = cIko; 
		Item.cChildren = 0; 
		ITS.hInsertAfter = InsertarDespuesDe;
		ITS.item = Item; 
		ITS.hParent = Parent;
		nNodo->_AsignarBase(this, TreeView_InsertItem(_hWnd, &ITS));
		_Nodos.push_back(nNodo);
		if (Parent != NULL) {
			_SetChildren(Parent, true);
		}
		return nNodo->hTreeItem(); 
	};




	HTREEITEM DTreeView::AgregarNodo(DTreeView_Nodo *nNodo, HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe) {
		TVINSERTSTRUCT ITS; 
		TVITEM         Item; 
		TCHAR          Tmp[128];
		DWLStrCopy(Tmp, 128, cTexto); 
		Item.pszText = Tmp; 
		Item.cchTextMax = static_cast<int>(DWLStrLen(Tmp));
		Item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN; 
		Item.state = TVIS_SELECTED; 
		Item.stateMask = TVIS_SELECTED; 
		Item.iImage = cIko;
		Item.iSelectedImage = cIko;
		Item.cChildren = 0;
		ITS.hInsertAfter = InsertarDespuesDe; 
		ITS.item = Item; 
		ITS.hParent = Parent; 
		nNodo->_AsignarBase(this, TreeView_InsertItem(_hWnd, &ITS), nColorFondo, nColorTexto); 
		_Nodos.push_back(nNodo); 
		if (Parent != NULL) { 
			_SetChildren(Parent, true);
		} 
		return nNodo->hTreeItem(); 
	};



	// Funcines para Agregar un Nodo normal.
	HTREEITEM DTreeView::AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, HTREEITEM InsertarDespuesDe) {
		TVINSERTSTRUCT ITS; 
		TVITEM         Item;
		TCHAR          Tmp[128];
		DWLStrCopy(Tmp, 128, cTexto); 
		Item.pszText = Tmp; 
		Item.cchTextMax = static_cast<int>(DWLStrLen(Tmp));
		Item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN; 
		Item.state = TVIS_SELECTED;
		Item.stateMask = TVIS_SELECTED; 
		Item.iImage = cIko; 
		Item.iSelectedImage = cIko; 
		Item.cChildren = 0; 
		ITS.hInsertAfter = InsertarDespuesDe; 
		ITS.item = Item; 
		ITS.hParent = Parent; 
		DTreeView_Nodo *nNodo = new DTreeView_Nodo(this, TreeView_InsertItem(_hWnd, &ITS));
		_Nodos.push_back(nNodo); 
		if (Parent != NULL) {
			_SetChildren(Parent, true); 
		} 
		return nNodo->hTreeItem(); 
	};




	HTREEITEM DTreeView::AgregarNodo(HTREEITEM Parent, const TCHAR *cTexto, const int cIko, COLORREF nColorTexto, COLORREF nColorFondo, HTREEITEM InsertarDespuesDe) { 
		TVINSERTSTRUCT ITS; 
		TVITEM         Item;
		TCHAR          Tmp[128];
		DWLStrCopy(Tmp, 128, cTexto); 
		Item.pszText = Tmp;
		Item.cchTextMax = static_cast<int>(DWLStrLen(Tmp)); 
		Item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN; 
		Item.state = TVIS_SELECTED; Item.stateMask = TVIS_SELECTED; 
		Item.iImage = cIko;
		Item.iSelectedImage = cIko; 
		Item.cChildren = 0;
		ITS.hInsertAfter = InsertarDespuesDe; 
		ITS.item = Item; 
		ITS.hParent = Parent; 
		DTreeView_Nodo *nNodo = new DTreeView_Nodo(this, TreeView_InsertItem(_hWnd, &ITS), nColorFondo, nColorTexto);
		_Nodos.push_back(nNodo); 
		if (Parent != NULL) { 
			_SetChildren(Parent, true); 
		} 
		return nNodo->hTreeItem(); 
	};



	// Funcines para Borrar Nodos.
	void DTreeView::BorrarNodo(HTREEITEM BNodo) {
		if (BNodo == NULL) {
			return;
		} 
		for (unsigned int i = 0; i < _Nodos.size(); i++) {
			if (_Nodos[i]->_Nodo == BNodo) {
				BorrarNodo(i);
				break;
			}
		}
	};




	void DTreeView::BorrarNodo(const unsigned int Pos) {
		HTREEITEM		NB   = _Nodos[Pos]->_Nodo;
		HTREEITEM		Hijo = TreeView_GetChild(_hWnd, NB);
		unsigned int	j;
		unsigned int	i;
		while (Hijo != NULL) { 
			for (j = 0; j < _Nodos.size(); j++) { 
				if (_Nodos[j]->_Nodo == Hijo) {
					break;
				}
			}  
			BorrarNodo(j);  
			Hijo = TreeView_GetChild(_hWnd, NB);
		}
		for (i = 0; i < _Nodos.size(); i++) { 
			if (_Nodos[i]->_Nodo == NB) {
				break;
			}
		}
		TreeView_DeleteItem(_hWnd, _Nodos[i]->_Nodo);
		delete _Nodos[i]; 
		_Nodos.erase(_Nodos.begin() + i); 
	};





	void DTreeView::BorrarTodo(void) {
		TreeView_DeleteAllItems(_hWnd);
		for (unsigned int i = 0; i < _Nodos.size(); i++) {
			delete _Nodos[i];
		}
		_Nodos.clear(); 
	};




	// Funcin que retorna un puntero DTreeView_Nodo partiendo de la ID Unica especificada.
	DTreeView_Nodo *DTreeView::BuscarNodo(HTREEITEM BNodo) {
		 for (unsigned int i = 0; i < _Nodos.size(); i ++) {
			 if (_Nodos[i]->_Nodo == BNodo) {
				 return _Nodos[i];  
			 }
		 } 
		 return NULL; 
	};





	 // Funcin para obtener la ID Unica del Nodo que esta en las coordenadas especificadas.
	HTREEITEM DTreeView::HitTest(const int cX, const int cY) {
		 TVHITTESTINFO ht; 
		 POINT         hitPt = { cX, cY };
		 ht.pt = hitPt; 
		 SendMessage(_hWnd, TVM_HITTEST, 0, (LPARAM)(LPTVHITTESTINFO) &ht); 
		 return ht.hItem; 
	};





	HTREEITEM DTreeView::HitTest(void) {
		 TVHITTESTINFO ht; 
		 RECT          Rect; 
		 POINT         hitPt; 
		 GetCursorPos(&hitPt);
		 RECT RV;
		 GetWindowRect(_hWnd, &RV);
		 hitPt.x -= RV.left;
		 hitPt.y -= RV.top; 
		 ht.pt = hitPt;
		 SendMessage(_hWnd, TVM_HITTEST, 0, (LPARAM)(LPTVHITTESTINFO) &ht); 
		 TreeView_GetItemRect(_hWnd, ht.hItem, &Rect, TRUE);
		 if (PtInRect(&Rect, hitPt) != 0) { 
			 return ht.hItem;
		 }
		 return NULL;
	};




	 // Esta Funcin usa las coordenadas en que esta situado el mouse
	 // Funcin que retorna el Nodo especificado en forma de Clase DTreeView_Nodo. 
	DTreeView_Nodo *DTreeView::Nodo(const unsigned int Pos) {
		return _Nodos[Pos];
	};


	/*
	// Funcin para convertir los scrollbars en flatscrollbars
	void DTreeView::FlatScrollBar(const bool FSB) { 
		 if (FSB == true) {	 ListView_SetExtendedListViewStyleEx(_hWnd, LVS_EX_FLATSB, LVS_EX_FLATSB); } 
		 else             { ListView_SetExtendedListViewStyleEx(_hWnd, LVS_EX_FLATSB, 0); } 
	};*/
	 



	LRESULT CALLBACK DTreeView::GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam) {
        DTreeView_Nodo *NodoTmp = NULL;
		switch (uMsg) {  
			case DWL_CUSTOM_DRAWDLG :
                // Para dialogos necesito hacer el SendMessage DWL_MSGRESULT, pero para ventanas debo retornar directamente _CustomDraw(lParam);
                SetWindowLong(GetParent(_hWnd), DWL_MSGRESULT, (LONG)_CustomDraw(lParam));
				return TRUE; 
			case DWL_CUSTOM_DRAWWND :
                // Para ventanas se enlaza directamente con la funcion _CustomDraw(lParam);
				return _CustomDraw(lParam); 
			case WM_LBUTTONUP : 
                lParam = MAKELPARAM(_uX, _uY);
                break;
			case WM_LBUTTONDOWN : 
                _uX = GET_X_LPARAM(lParam);
                _uY = GET_Y_LPARAM(lParam);
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_CLICK_IZQUIERDO, ID(), lParam);
				break; 
			case WM_RBUTTONDOWN : 
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_CLICK_DERECHO, ID(), lParam);
				break; 
			case WM_MBUTTONDOWN : 
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_CLICK_MEDIO, ID(), lParam);
				break; 
			case WM_LBUTTONDBLCLK : 
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_DOBLECLICK_IZQUIERDO, ID(), lParam);
				break; 
			case WM_RBUTTONDBLCLK : 
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_DOBLECLICK_DERECHO, ID(), lParam);
				break; 
			case WM_MBUTTONDBLCLK : 
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_DOBLECLICK_MEDIO, ID(), lParam);
				break; 
			case WM_KEYDOWN :
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_TECLADO_PRESIONADO, wParam, (LPARAM)ID()); 
				break; 
			case WM_KEYUP :
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_TECLADO_SOLTADO, wParam, (LPARAM)ID()); 
				if (wParam == 13) PostMessage(GetParent(_hWnd), DWL_TREEVIEW_TECLADO_INTRO, wParam, (LPARAM)ID());  
				break; 
			case WM_SETFOCUS :
				CancelarLabelEdit();  
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_FOCO_OBTENIDO, ID(), 0); 
				break;
			case WM_KILLFOCUS :
				PostMessage(GetParent(_hWnd), DWL_TREEVIEW_FOCO_PERDIDO, ID(), 0); 
				break;
			case TVM_EDITLABEL :
				return (LRESULT)EmpezarLabelEdit(BuscarNodo((HTREEITEM)lParam), false); 
            case DWL_TREEVIEW_NODO_EXPANDIENDO :
                NodoTmp = BuscarNodo(((LPNMTREEVIEW)lParam)->itemNew.hItem);
                this->TreeView_Evento_Nodo_Expandiendo(NodoTmp);
                return SendMessage(GetParent(_hWnd), DWL_TREEVIEW_NODO_EXPANDIENDO, (WPARAM)NodoTmp, (LPARAM)ID());
            case DWL_TREEVIEW_NODO_CAMBIOSELECCION :
                NodoTmp = BuscarNodo(((LPNMTREEVIEW)lParam)->itemNew.hItem);
                return SendMessage(GetParent(_hWnd), DWL_TREEVIEW_NODO_CAMBIOSELECCION, (WPARAM)NodoTmp, (LPARAM)ID());
			case WM_NOTIFY : 
                // Notificaciones que devuelve el editbox del LabelEdit
				switch (((LPNMHDR)lParam)->code) { 
					case NM_KEYDOWN : 
							switch(((LPNMKEY)lParam)->nVKey) { 
							case VK_RETURN : 
								TerminarLabelEdit();	
								break; 
							case VK_ESCAPE : 
								CancelarLabelEdit();	
								break; 
						}	
						break;
					case NM_KILLFOCUS : 
						CancelarLabelEdit();
						break; 
				}  
				break;
		} 
		return DBaseControlWin::GestorMensajes(uMsg, wParam, lParam); 
	}; 




	// Funcin que se encarga de especificar los colores y la Fuente del TreeView para cada nodo
	LRESULT DTreeView::_CustomDraw(LPARAM Datos) { 
		LPNMTVCUSTOMDRAW  lplvcd       = (LPNMTVCUSTOMDRAW)Datos;
		switch(lplvcd->nmcd.dwDrawStage) { 
			 case CDDS_PREPAINT :   
				 return CDRF_NOTIFYITEMDRAW; 
				 break;  
			 case CDDS_ITEMPREPAINT : 
				 for (unsigned int i = 0; i < _Nodos.size(); i++) {
					 if ((HTREEITEM)lplvcd->nmcd.dwItemSpec == _Nodos[i]->_Nodo) { 
							
/*						#if defined _DEBUG
							DWL::DWLDebug::ImprimirDebug(TEXT("DTreeView::_CustomDraw NodoSel %d , NodoActual %d\n"), lplvcd->nmcd.dwItemSpec, _Nodos[i]->_Nodo);
						#endif*/
						if (_Nodos[i]->_Nodo != (HTREEITEM)TreeView_GetSelection(_hWnd)) { 
							lplvcd->clrTextBk = _Nodos[i]->_ColorFondo; 
							lplvcd->clrText = _Nodos[i]->_ColorTexto;    
						}    
/*						else { 
							lplvcd->clrTextBk = _ColorSeleccion;  
							lplvcd->clrText = _ColorSeleccionTexto;  
						}	*/
						if (_Nodos[i]->_Fuente != NULL) { 
							SelectObject(lplvcd->nmcd.hdc, _Nodos[i]->_Fuente);  
						}	
						else {	 
							SelectObject(lplvcd->nmcd.hdc, _Fuente);	
						}     
					}
				}
				return CDRF_NEWFONT; 
				break;
		} 
		return 0;
	};



	                          
	// Funcin para asignar si el nodo tiene hijos o no..
	void DTreeView::_SetChildren(HTREEITEM IC, const bool TieneHijos) { 
		TVITEM TvItem;
		TvItem.mask = TVIF_HANDLE | TVIF_CHILDREN; 
		TvItem.cChildren = static_cast<int>(TieneHijos); 
		TvItem.hItem = IC; 
		TreeView_SetItem(_hWnd, &TvItem);
	};
	                          
		



	HWND DTreeView::EmpezarLabelEdit(DTreeView_Nodo *nNodo, const bool Numerico) {
		CancelarLabelEdit();
		if (nNodo == NULL) return NULL; 
		_eNodo = nNodo; 
		RECT Dim;  
		_Editando = true;
		TreeView_GetItemRect(_hWnd, nNodo->_Nodo, &Dim, TRUE);
		long Estilos;  
		if (Numerico == false) { Estilos = WS_BORDER | ES_AUTOHSCROLL | WS_CHILD; }  
		else                   { Estilos = WS_BORDER | ES_AUTOHSCROLL | WS_CHILD | ES_NUMBER; } 
		Dim.right += 30;
        DString Texto;
        nNodo->ObtenerTexto(Texto);
		_hWndEdit = CreateWindow(TEXT("EDIT"), Texto(), Estilos, Dim.left - 5, Dim.top , Dim.right - (Dim.left) + 10, Dim.bottom - (Dim.top), _hWnd, (HMENU)555, GetModuleHandle(NULL), NULL);
		SetWindowLongPtr(_hWndEdit, GWLP_USERDATA, (LONG_PTR)this);
//			_GestorMensajesOriginalEdit = (WNDPROC)SetWindowLongPtr(_hWndEdit, GWL_WNDPROC, (long)_GestorMensajesEdit); 
		_GestorMensajesOriginalEdit = (WNDPROC)SetWindowLongPtr(_hWndEdit, GWLP_WNDPROC, (LONG_PTR)_GestorMensajesEdit); 


        SendMessage(_hWndEdit, EM_SETSEL, 0, Texto.Tam());
		SendMessage(_hWndEdit, WM_SETFONT, (WPARAM)nNodo->_Fuente, 0); 
		SendMessage(_hWndEdit, EM_SETLIMITTEXT, 0, 0);
		_BrochaFondoEdit = CreateSolidBrush(nNodo->_ColorFondo); 
		ShowWindow (_hWndEdit, SW_SHOWNORMAL); 
		UpdateWindow(_hWndEdit);  
		SetFocus(_hWndEdit); 
		PostMessage(GetParent(_hWnd), DWL_TREEVIEW_LABELEDIT_INICIO, (WPARAM)_eNodo, static_cast<int>(ID()));
		return _hWndEdit; 
	}


	void DTreeView::TerminarLabelEdit(void) {
		if (_hWndEdit != NULL && _Editando == true) { 
			TCHAR Txt[512];
			GetDlgItemText(GetParent(_hWndEdit), static_cast<int>(GetWindowLongPtr(_hWndEdit, GWL_ID)), Txt, 512);
			DestroyWindow(_hWndEdit);	
			DeleteObject(_BrochaFondoEdit);	
			
			DTreeView_TerminarLabelEdit Edicion(_eNodo, Txt);
			SendMessage(GetParent(_hWnd), DWL_TREEVIEW_LABELEDIT_FIN, reinterpret_cast<WPARAM>(&Edicion), static_cast<int>(ID()));
			if (Edicion.Cancelar == false) _eNodo->AsignarTexto(Edicion.NuevoTexto); 	 
			_Editando = false; 
			RECT Dim; 
			TreeView_GetItemRect(_hWnd, _eNodo->_Nodo, &Dim, TRUE);
			InvalidateRect(_hWnd, &Dim, false);  
			_eNodo = NULL;
		} 
	}

	// Funcin que cancela la edicion de un item/subitem
	void DTreeView::CancelarLabelEdit(void) { 
		if (_hWndEdit != NULL && _Editando == true) {
			_Editando = false;  
			DestroyWindow(_hWndEdit);
			DeleteObject(_BrochaFondoEdit);	
			_eNodo->Seleccionar();
			PostMessage(GetParent(_hWnd), DWL_TREEVIEW_LABELEDIT_CANCELADO, (WPARAM)_eNodo, static_cast<int>(ID()));
			_eNodo = NULL;
		} 
	}




	 // WindowProcedure que usara el Editbox en la Funcin editlabel
	LRESULT CALLBACK DTreeView::_GestorMensajesEdit(HWND dhWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) { 
		DTreeView *This = reinterpret_cast<DTreeView *>(GetWindowLongPtr(dhWnd, GWLP_USERDATA));  
		NMHDR T; 
		T.hwndFrom = dhWnd;
		T.idFrom = GetWindowLongPtr(dhWnd, GWL_ID); 
		switch (uMsg) {  
			case WM_CTLCOLOREDIT : 
			case WM_CTLCOLORSTATIC : 
				//This->Item(This->_eItem)->ColorFondo(This->_eSubItem);
				SetTextColor((HDC)wParam, This->_eNodo->_ColorTexto);
				SetBkColor((HDC)wParam, This->_eNodo->_ColorFondo);
	//			SetBkMode((HDC)wParam, TRANSPARENT);	
				return (LRESULT)This->_BrochaFondoEdit; 
/*			case WM_LBUTTONUP : 	 
				T.code = NM_CLICK; 	
	//			PostMessage(GetParent(dhWnd), WM_NOTIFY, 0, (long)&T);  
				This->GestorMensajes(WM_NOTIFY, 0, reinterpret_cast<WPARAM>(&T));
				break;   
			case WM_RBUTTONUP : 
				T.code = NM_RCLICK; 	
				This->GestorMensajes(WM_NOTIFY, 0, reinterpret_cast<WPARAM>(&T));
	//			PostMessage(GetParent(dhWnd), WM_NOTIFY, 0, (long)&T);
				break; 		
			case WM_LBUTTONDBLCLK : 
				T.code = NM_DBLCLK; 
	//			PostMessage(GetParent(dhWnd), WM_NOTIFY, 0, (long)&T); 	
				This->GestorMensajes(WM_NOTIFY, 0, reinterpret_cast<WPARAM>(&T));
				break; */
            case WM_KEYUP :
				NMKEY Key;	
				T.code = NM_KEYDOWN;
				Key.hdr = T;	
				Key.nVKey = (unsigned int)wParam;
				Key.uFlags = (unsigned int)lParam; 
                This->GestorMensajes(WM_NOTIFY, 0, reinterpret_cast<WPARAM>(&Key));
                break;
			case WM_CHAR : 
				NMKEY Key2;	
				T.code = NM_KEYDOWN;
				Key2.hdr = T;	
				Key2.nVKey = (unsigned int)wParam;
				Key2.uFlags = (unsigned int)lParam; 
				This->GestorMensajes(WM_NOTIFY, 0, reinterpret_cast<WPARAM>(&Key2));
	/*			if (wParam == 13) {   		
					T.code = NM_RETURN;  	
					PostMessage(GetParent(dhWnd), WM_NOTIFY, 0, (long)&T);  
				}	 */
				break;
								
		} 
		return CallWindowProc(This->_GestorMensajesOriginalEdit, dhWnd, uMsg, wParam, lParam);
	};



};